/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book;

import net.minecraft.class_2960;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerBookIDs;
import slimeknights.tconstruct.library.client.book.content.ContentMaterial;
import slimeknights.tconstruct.library.client.book.content.ContentMaterialSkull;
import slimeknights.tconstruct.library.client.book.content.ContentModifier;
import slimeknights.tconstruct.library.client.book.content.ContentTool;
import slimeknights.tconstruct.library.client.book.content.RangedMaterialContent;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ModifierSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ToolSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.SkullMaterialSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.TierRangeMaterialSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.TieredMaterialSectionTransformer;
import slimeknights.tconstruct.shared.item.TinkerBookItem;
import slimeknights.tconstruct.tools.stats.BowstringMaterialStats;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class TinkerBook
extends BookData {
    public static final BookData MATERIALS_AND_YOU = BookLoader.registerBook(TinkerBookIDs.MATERIALS_BOOK_ID, false, false, new BookRepository[0]);
    public static final BookData PUNY_SMELTING = BookLoader.registerBook(TinkerBookIDs.PUNY_SMELTING_ID, false, false, new BookRepository[0]);
    public static final BookData MIGHTY_SMELTING = BookLoader.registerBook(TinkerBookIDs.MIGHTY_SMELTING_ID, false, false, new BookRepository[0]);
    public static final BookData TINKERS_GADGETRY = BookLoader.registerBook(TinkerBookIDs.TINKERS_GADGETRY_ID, false, false, new BookRepository[0]);
    public static final BookData FANTASTIC_FOUNDRY = BookLoader.registerBook(TinkerBookIDs.FANTASTIC_FOUNDRY_ID, false, false, new BookRepository[0]);
    public static final BookData ENCYCLOPEDIA = BookLoader.registerBook(TinkerBookIDs.ENCYCLOPEDIA_ID, false, false, new BookRepository[0]);

    public TinkerBook() {
        super(new BookRepository[0]);
    }

    public static void initBook() {
        BookLoader.registerPageType(ContentMaterial.ID, ContentMaterial.class);
        BookLoader.registerPageType(ContentTool.ID, ContentTool.class);
        BookLoader.registerPageType(ContentModifier.ID, ContentModifier.class);
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("melee_harvest"), ContentMaterial::new, HeadMaterialStats.ID, HandleMaterialStats.ID, ExtraMaterialStats.ID);
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("ranged"), RangedMaterialContent::new, LimbMaterialStats.ID, GripMaterialStats.ID, BowstringMaterialStats.ID);
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("skull"), ContentMaterialSkull::new, SkullStats.ID);
        ToolSectionTransformer armorTransformer = new ToolSectionTransformer("armor");
        MATERIALS_AND_YOU.addTransformer(ToolSectionTransformer.INSTANCE);
        MATERIALS_AND_YOU.addTransformer(armorTransformer);
        MIGHTY_SMELTING.addTransformer(ToolSectionTransformer.INSTANCE);
        FANTASTIC_FOUNDRY.addTransformer(armorTransformer);
        TINKERS_GADGETRY.addTransformer(armorTransformer);
        TINKERS_GADGETRY.addTransformer(new ToolSectionTransformer("staffs"));
        ENCYCLOPEDIA.addTransformer(new ToolSectionTransformer("tools"));
        ENCYCLOPEDIA.addTransformer(armorTransformer);
        MATERIALS_AND_YOU.addTransformer(new TieredMaterialSectionTransformer("tier_one_materials", 1, false));
        PUNY_SMELTING.addTransformer(new TieredMaterialSectionTransformer("tier_two_materials", 2, false));
        MIGHTY_SMELTING.addTransformer(new TieredMaterialSectionTransformer("tier_three_materials", 3, false));
        FANTASTIC_FOUNDRY.addTransformer(new TieredMaterialSectionTransformer("tier_four_materials", 4, false));
        TINKERS_GADGETRY.addTransformer(new SkullMaterialSectionTransformer("skull_materials", false));
        ENCYCLOPEDIA.addTransformer(new TieredMaterialSectionTransformer("tier_one_materials", 1, true));
        ENCYCLOPEDIA.addTransformer(new TieredMaterialSectionTransformer("tier_two_materials", 2, true));
        ENCYCLOPEDIA.addTransformer(new TieredMaterialSectionTransformer("tier_three_materials", 3, true));
        ENCYCLOPEDIA.addTransformer(new TieredMaterialSectionTransformer("tier_four_materials", 4, true));
        ENCYCLOPEDIA.addTransformer(new SkullMaterialSectionTransformer("skull_materials", true));
        ModifierSectionTransformer upgrades = new ModifierSectionTransformer("upgrades");
        ModifierSectionTransformer defense = new ModifierSectionTransformer("defense");
        ModifierSectionTransformer slotless = new ModifierSectionTransformer("slotless");
        ModifierSectionTransformer abilities = new ModifierSectionTransformer("abilities");
        PUNY_SMELTING.addTransformer(upgrades);
        PUNY_SMELTING.addTransformer(slotless);
        MIGHTY_SMELTING.addTransformer(defense);
        MIGHTY_SMELTING.addTransformer(abilities);
        ENCYCLOPEDIA.addTransformer(upgrades);
        ENCYCLOPEDIA.addTransformer(defense);
        ENCYCLOPEDIA.addTransformer(slotless);
        ENCYCLOPEDIA.addTransformer(abilities);
        TinkerBook.addStandardData(MATERIALS_AND_YOU, TinkerBookIDs.MATERIALS_BOOK_ID);
        TinkerBook.addStandardData(PUNY_SMELTING, TinkerBookIDs.PUNY_SMELTING_ID);
        TinkerBook.addStandardData(MIGHTY_SMELTING, TinkerBookIDs.MIGHTY_SMELTING_ID);
        TinkerBook.addStandardData(FANTASTIC_FOUNDRY, TinkerBookIDs.FANTASTIC_FOUNDRY_ID);
        TinkerBook.addStandardData(TINKERS_GADGETRY, TinkerBookIDs.TINKERS_GADGETRY_ID);
        TinkerBook.addStandardData(ENCYCLOPEDIA, TinkerBookIDs.ENCYCLOPEDIA_ID);
    }

    private static void addStandardData(BookData book, class_2960 id) {
        book.addRepository(new FileRepository(new class_2960(id.method_12836(), "book/" + id.method_12832())));
        book.addTransformer(BookTransformer.indexTranformer());
        book.addTransformer(BookTransformer.paddingTransformer());
        book.addTransformer(TierRangeMaterialSectionTransformer.INSTANCE);
    }

    public static BookData getBook(TinkerBookItem.BookType bookType) {
        return switch (bookType) {
            default -> throw new IncompatibleClassChangeError();
            case TinkerBookItem.BookType.MATERIALS_AND_YOU -> MATERIALS_AND_YOU;
            case TinkerBookItem.BookType.PUNY_SMELTING -> PUNY_SMELTING;
            case TinkerBookItem.BookType.MIGHTY_SMELTING -> MIGHTY_SMELTING;
            case TinkerBookItem.BookType.TINKERS_GADGETRY -> TINKERS_GADGETRY;
            case TinkerBookItem.BookType.FANTASTIC_FOUNDRY -> FANTASTIC_FOUNDRY;
            case TinkerBookItem.BookType.ENCYCLOPEDIA -> ENCYCLOPEDIA;
        };
    }
}

